import {AnyRemote} from "./index";
import {watch} from "vue";

export default {
    install(app, options) {
        const anyRemote = new AnyRemote()
        const {wsOpts, agoraConfig, recordConfig, wsOpen} = options
        watch(() => wsOpen.value, function (value) {
            console.log('value here', value)
            if (value) {
                const {url, tabVisibleCB, connectionLostCB, wsSocketChannelName} = wsOpts()
                anyRemote.configureWS(
                    url, tabVisibleCB, connectionLostCB, wsSocketChannelName
                );
            } else {
                anyRemote?.wsInt?.close(true);
            }
        }, {
            immediate: true
        })
        app.provide('AnyR', anyRemote);
        anyRemote.configureAgora(agoraConfig, recordConfig)
            .then(function () {
            })
    }
}