import {Ref} from "vue";
import {displayError} from "../../components/Global/MessagePrompt/functionals/triggerMessagePrompt";

export async function fetchCommonFuncSimplified(
    f: Function,
    params: any,
    txt: any,
    cb: Function,
    loaderRef?: Ref<boolean>,
    judgeFunc = (a: any) => a.data.code.toString() === '200',
) {
    try {
        if (loaderRef) {
            loaderRef.value = true
        }
        const res = await f.call(null, ...params);
        if (judgeFunc(res)) {
            cb(res)
        } else {
            console.log('请求出错！！！', res)
            throw new Error(`请求${txt}出错！`)
        }
    } catch (e: any) {
        console.log('error in fetch', e);
        displayError(`处理${txt}失败，错误信息：${e.message}`);
    } finally {
        if (loaderRef) {
            loaderRef.value = false
        }
    }
}

export async function fetchCommonFunc(
    f: Function,
    params: any,
    txt: any,
    cb: Function,
    loaderRef?: Ref<boolean>,
) {
    try {
        if (loaderRef) {
            loaderRef.value = true
        }
        const res = await f.call(null, ...params);
        cb(res);
    } catch (e: any) {
        console.log('error in fetch', e);
        displayError(`处理${txt}失败，错误信息：${e.message}`);
    } finally {
        if (loaderRef) {
            loaderRef.value = false
        }
    }
}
