export const makeSID = function (length = 32) {
    if (window.crypto && window.crypto.getRandomValues !== undefined) {
        const buffer = new Uint8Array(length)
        window.crypto.getRandomValues(buffer)
        return buffer.reduce((q, w) => q + w.toString(16).padStart(2, '0'), "")
    }
    return Math.random() * 1000 + Math.random()
}

const BrowserKeyId = 'B-K-ID-$$$';

export function getBrowserDeviceId() {
    let browserId = localStorage[BrowserKeyId];
    if (!browserId) {
        browserId = makeSID(16);
        localStorage[BrowserKeyId] = browserId;
    }
    return browserId
}