import projectUiConfig from '../../project.ui.config'

// 改变ArcoUI框架的主题
export function changeTailwindTheme(themeName: string) {
    document.body.setAttribute('class', themeName)
}

// tailwind的UI变量设置
export const tailwindUiConfig = {
    // 定义主色，这里简化一点，就直接动态改变
    colors: {
        'primary-light': projectUiConfig.colors.primary,
        'primary-hover-light': projectUiConfig.colors.primaryHover,
        'primary-pressed-light': projectUiConfig.colors.primaryPressed,
        'primary-activated-light': projectUiConfig.colors.primaryActivated,
        'primary-disable-light': projectUiConfig.colors.primaryDisable,
        'theme-bg1-light': projectUiConfig.colors.themeBg1,
        'theme-bg2-light': projectUiConfig.colors.themeBg2,
        'theme-bg3-light': projectUiConfig.colors.themeBg3,
        'theme-bg4-light': projectUiConfig.colors.themeBg4,
        'theme-bg5-light': projectUiConfig.colors.themeBg5,
        'theme-text1-light': projectUiConfig.colors.themeText1,
        'theme-text2-light': projectUiConfig.colors.themeText2,
        'theme-text3-light': projectUiConfig.colors.themeText3,
        'theme-text4-light': projectUiConfig.colors.themeText4,
        'theme-text5-light': projectUiConfig.colors.themeText5,
        'theme-fill1-light': projectUiConfig.colors.themeFill1,
        'theme-fill2-light': projectUiConfig.colors.themeFill2,
        'theme-fill3-light': projectUiConfig.colors.themeFill3,
        'theme-fill4-light': projectUiConfig.colors.themeFill4,
        'primary-dark': projectUiConfig.colors.darkPrimary,
        'primary-hover-dark': projectUiConfig.colors.darkPrimaryHover,
        'primary-pressed-dark': projectUiConfig.colors.darkPrimaryPressed,
        'primary-activated-dark': projectUiConfig.colors.darkPrimaryActivated,
        'primary-disable-dark': projectUiConfig.colors.darkPrimaryDisable,
        'theme-bg1-dark': projectUiConfig.colors.darkThemeBg1,
        'theme-bg2-dark': projectUiConfig.colors.darkThemeBg2,
        'theme-bg3-dark': projectUiConfig.colors.darkThemeBg3,
        'theme-bg4-dark': projectUiConfig.colors.darkThemeBg4,
        'theme-bg5-dark': projectUiConfig.colors.darkThemeBg5,
        'theme-text1-dark': projectUiConfig.colors.darkThemeText1,
        'theme-text2-dark': projectUiConfig.colors.darkThemeText2,
        'theme-text3-dark': projectUiConfig.colors.darkThemeText3,
        'theme-text4-dark': projectUiConfig.colors.darkThemeText4,
        'theme-text5-dark': projectUiConfig.colors.darkThemeText5,
        'theme-fill1-dark': projectUiConfig.colors.darkThemeFill1,
        'theme-fill2-dark': projectUiConfig.colors.darkThemeFill2,
        'theme-fill3-dark': projectUiConfig.colors.darkThemeFill3,
        'theme-fill4-dark': projectUiConfig.colors.darkThemeFill4
    },
    // 定义间距
    spacing: {
        xxs: projectUiConfig.spacing.xxs,
        xs: projectUiConfig.spacing.xs,
        sm: projectUiConfig.spacing.sm,
        md: projectUiConfig.spacing.md,
        lg: projectUiConfig.spacing.lg,
        xl: projectUiConfig.spacing.xl,
        '2xl': projectUiConfig.spacing.x2l,
        '3xl': projectUiConfig.spacing.x3l,
        '4xl': projectUiConfig.spacing.x4l,
        '5xl': projectUiConfig.spacing.x5l,
        '6xl': projectUiConfig.spacing.x6l,
        '7xl': projectUiConfig.spacing.x7l,
        '8xl': projectUiConfig.spacing.x8l,
        '9xl': projectUiConfig.spacing.x9l
    },
    // 定义圆角
    borderRadius: {
        xs: projectUiConfig.borderRadius.xs,
        sm: projectUiConfig.borderRadius.sm,
        md: projectUiConfig.borderRadius.md,
        lg: projectUiConfig.borderRadius.lg,
        xl: projectUiConfig.borderRadius.xl
    },
    borderWidth: {
        xs: projectUiConfig.borderWidth.xs,
        sm: projectUiConfig.borderWidth.sm,
        md: projectUiConfig.borderWidth.md,
        lg: projectUiConfig.borderWidth.lg,
        xl: projectUiConfig.borderWidth.xl
    },
    // 新加的角度
    rotate: {
        '30': '30deg',
        '60': '60deg'
    },
    // 新加的缩放
    scale: {
        '20': '.2',
        '25': '.25',
        '30': '.3',
        '66': '.66',
        '80': '.8',
        '200': '.2'
    },
    // 动画延时
    transitionDelay: {
        '1250': '1250ms',
        '1500': '1500ms',
        '1750': '1750ms',
        '2000': '2000ms',
        '2250': '2250ms',
        '2500': '2500ms',
        '2750': '2750ms',
        '3000': '3000ms'
    },
    // 动画周期
    transitionDuration: {
        '1250': '1250ms',
        '1500': '1500ms',
        '1750': '1750ms',
        '2000': '2000ms',
        '2250': '2250ms',
        '2500': '2500ms',
        '2750': '2750ms',
        '3000': '3000ms'
    },
    // 层级
    zIndex: {
        '60': '60',
        '70': '70',
        '80': '80',
        '90': '90',
        '100': '100',
        '200': '200',
        '300': '300',
        '400': '400',
        '500': '500',
        '600': '600',
        '700': '700',
        '800': '800',
        '900': '900',
        '1000': '1000',
        '1100': '1100'
    },
    backgroundColor: {}
}
