/**
 * 缓存同一参数下的异步请求或者类似方法的结果
 * @param f {Function} 待缓存的方法
 */
export function cacheAPICallAsync(f: Function) {
    const cacheHit = new Map<String, any>()
    return async function (...arg:any[]) {
        const argsStr = JSON.stringify(arg)
        const cacheGet = cacheHit.get(argsStr)
        if (cacheGet) {
            return cacheGet
        }
        const resp = await f.call(null, ...arg);
        cacheHit.set(argsStr, resp);
        return resp;
    }
}