use crate::utils::json_utils;
use serde::{Deserialize, Serialize};

// 定义服务器心跳数据消息结构
#[derive(Serialize, Deserialize, Debug)]
pub struct HeartMessage {
    #[serde(rename = "msgType")]
    pub msg_type: String,
    #[serde(rename = "fromId")]
    pub from_id: String,
    #[serde(rename = "fromName")]
    pub from_name: String,
    #[serde(rename = "toId")]
    pub to_id: String,
    #[serde(rename = "msgData")]
    pub msg_data: String,
    #[serde(rename = "time")]
    pub time: u128,
}

pub fn heart_resp(to_id: &str) -> serde_json::Result<String> {
    serde_json::to_string(&HeartMessage {
        msg_type: "Heart".to_string(),
        from_id: "0".to_string(),
        from_name: "Server".to_string(),
        msg_data: "".to_string(),
        to_id: to_id.to_string(),
        time: json_utils::get_current_timestamp(),
    })
}
