use reqwest::{Client, header::{HeaderMap, HeaderValue}};
use std::error::Error;

const URL: &str = "http://localhost:8061/addChatMsg";

pub async fn send_request(
    from_id: &str,
    to_id: &str,
    msg_json: &str,
) -> Result<String, Box<dyn Error>> {
    // 创建 multipart 表单
    let form = reqwest::multipart::Form::new()
        .text("fromId", from_id.to_string())
        .text("toId", to_id.to_string())
        .text("msgJson", msg_json.to_string())
        .text("projectName", "mu")
        .text("apiPwd", "Ifar$2_0160_525_Mocp");

    // 创建自定义请求头
    let mut headers = HeaderMap::new();
    headers.insert(
        "apiPwd",
        HeaderValue::from_str("Ifar$2_0160_525_Mocp")?,
    );
    headers.insert(
        "exchangeToken",
        HeaderValue::from_str("Hzk8eQ7pywU8vg2WweQM*3hTxd#2jJp@")?,
    );

    // 创建 HTTP 客户端
    let client = Client::builder()
        .default_headers(headers)
        .build()?;

    // 发送请求
    let response = client
        .post(URL)
        .multipart(form)
        .send()
        .await?;

    // 处理响应
    let status = response.status();
    let body = response.text().await?;

    if status.is_success() {
        Ok(body)
    } else {
        Err(format!("Request failed with status: {}, body: {}", status, body).into())
    }
}