extern crate core;

mod client;
mod config;
mod events;
mod handles;
mod typing;
mod utils;
mod deport;

use crate::events::handle_events;
use client::handle_client;
use tokio::net::TcpListener;
use tokio::sync::mpsc;
use utils::utils::get_addr;

#[tokio::main]
async fn main() {

    let bind_addr = match get_addr() {
        Ok(other_addr) => other_addr,
        Err(err) => {
            eprintln!("Error: {}", err);
            std::process::exit(1);
        }
    };

    let listener = TcpListener::bind(bind_addr).await.unwrap();
    // 创建事件通道
    let (event_sender, event_receiver) = mpsc::unbounded_channel();
    // 启动事件处理任务
    tokio::spawn(handle_events(event_receiver));
    while let Ok((stream, _)) = listener.accept().await {
        // 创建一个用于事件中心向客户端发送消息的通道
        let (center_to_client_sender, center_to_client_receiver) = mpsc::unbounded_channel();
        tokio::spawn(handle_client(
            stream,
            event_sender.clone(),
            center_to_client_sender,
            center_to_client_receiver,
        ));
    }
}
