use serde::{Deserialize, Serialize};

// 定义消息结构
#[derive(Serialize, Deserialize, Debug)]
pub struct ClientMessageData {
    #[serde(rename = "msgType")]
    pub msg_type: String,
    #[serde(rename = "fromID")]
    pub from_id: String,
    #[serde(rename = "fromName")]
    pub from_name: String,
    #[serde(rename = "msgData")]
    pub msg_data: serde_json::Value,
    #[serde(rename = "toID")]
    pub to_id: String
}

#[derive(Serialize, Deserialize, Debug)]
pub struct OtherLoginMessageData {
    #[serde(rename = "msgType")]
    pub msg_type: String,
    #[serde(rename = "fromID")]
    pub from_id: String,
    #[serde(rename = "fromName")]
    pub from_name: String,
    #[serde(rename = "msgData")]
    pub msg_data: serde_json::Value,
    #[serde(rename = "toID")]
    pub to_id: String
}