use crate::typing::message_typed::ClientMessageData;
use serde_json::Result;
use std::time::{SystemTime, UNIX_EPOCH};

pub fn get_current_timestamp() -> u128 {
    let now = SystemTime::now();
    let duration_since_epoch = now.duration_since(UNIX_EPOCH).expect("时间戳计算出错");
    duration_since_epoch.as_millis()
}

// 解析 JSON 消息
pub fn parse_message(json_str: &str) -> Result<ClientMessageData> {
    serde_json::from_str(json_str)
}
